/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

/* Compiled with Shaderforth: https://github.com/daeken/Shaderforth
import[ noise ]

:globals
	@vec3 uniform =iResolution
	@float uniform =iGlobalTime
;

:m time iGlobalTime tmod + ;

iResolution frag->position =p

:m blend /{ ( x ) [ x .yz.x 1 mod swap ] -1 1 clamp } \+ ;
:m blend-avg !size =>s /{ ( x ) [ x .yz.x 1 mod swap ] -1 1 clamp } \+ s / ;

:m center-mod ( x a ) x a deg->rad mod a 2 / deg->rad - a 2 / deg->rad / ;

: base ( tmod:float p:vec2 -> vec3 )
	p cart->polar =p
	[ p .y pi * time 7 / sin * 0 ] p + =p
	time p - =p
	[ p .x 90 center-mod p .y ] polar-norm =d
	[ d .x time + [ d .x d .y 5 * d .y time sin 2 d .x * * * ] length sin abs p .x 8 * sin abs ]
;

: shadow ( tmod:float p:vec2 -> vec3 )
	p cart->polar =p
	time sin 3 ** abs .5 1 clamp =pulse
	[ 0 p .y neg pulse * dup ]
;

$[-.5:+.5:.125] /{ ( tmod )
	[
		tmod p base
		tmod p shadow
	] blend hsv1->rgb
} !size =>s \+ s 2 / / ->fragcolor
*/

vec2 cart_polar(vec2 p) {
	return vec2(atan(p.y, p.x), length(p));
}
vec3 hsv1_rgb(vec3 hsv) {
	return mix(vec3(1., 1., 1.), clamp(abs(mod(hsv.x * 6. + vec3(0., 4., 2.), 6.) - 3.) - 1., 0., 1.), hsv.y) * hsv.z;
}
vec2 polar_norm(vec2 p) {
	return vec2(mod(p.x + 6.2832, 6.2832), p.y);
}
vec3 shadow(float tmod, vec2 p) {
	p = cart_polar(p);
	float pulse = clamp(abs(pow(sin(iGlobalTime + tmod), 3.)), .5, 1.);
	float var_3 = -p.y * pulse;
	return vec3(0., var_3, var_3);
}
vec3 base(float tmod, vec2 p) {
	p = cart_polar(p);
	p = vec2(p.y * 3.14159 * sin((iGlobalTime + tmod) / 7.), 0.) + p;
	p = iGlobalTime + tmod - p;
	vec2 d = polar_norm(vec2((mod(p.x, 1.5708) - .78538) / .78538, p.y));
	return vec3(d.x + iGlobalTime + tmod, abs(sin(length(vec3(d.x, d.y * 5., d.y * sin(iGlobalTime + tmod) * 2. * d.x)))), abs(sin(p.x * 8.)));
}
void main() {
	vec2 p = (gl_FragCoord.xy / iResolution.xy * 2. - 1.) * vec2(iResolution.x / iResolution.y, 1.);
	gl_FragColor = vec4((hsv1_rgb(clamp(vec3(mod(base(-.5, p).x, 1.), base(-.5, p).yz), -1., 1.) + clamp(vec3(mod(shadow(-.5, p).x, 1.), shadow(-.5, p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(-.375, p).x, 1.), base(-.375, p).yz), -1., 1.) + clamp(vec3(mod(shadow(-.375, p).x, 1.), shadow(-.375, p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(-.250, p).x, 1.), base(-.250, p).yz), -1., 1.) + clamp(vec3(mod(shadow(-.250, p).x, 1.), shadow(-.250, p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(-.125, p).x, 1.), base(-.125, p).yz), -1., 1.) + clamp(vec3(mod(shadow(-.125, p).x, 1.), shadow(-.125, p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(0., p).x, 1.), base(0., p).yz), -1., 1.) + clamp(vec3(mod(shadow(0., p).x, 1.), shadow(0., p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(.125, p).x, 1.), base(.125, p).yz), -1., 1.) + clamp(vec3(mod(shadow(.125, p).x, 1.), shadow(.125, p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(.250, p).x, 1.), base(.250, p).yz), -1., 1.) + clamp(vec3(mod(shadow(.250, p).x, 1.), shadow(.250, p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(.375, p).x, 1.), base(.375, p).yz), -1., 1.) + clamp(vec3(mod(shadow(.375, p).x, 1.), shadow(.375, p).yz), -1., 1.)) + hsv1_rgb(clamp(vec3(mod(base(.500, p).x, 1.), base(.500, p).yz), -1., 1.) + clamp(vec3(mod(shadow(.500, p).x, 1.), shadow(.500, p).yz), -1., 1.))) / 4.5, 1.);
   gl_FragColor.a = length(gl_FragColor.rgb);
}
